/*
 * Decompiled with CFR 0.152.
 */
package com.achep.header2actionbar;

import android.content.Context;
import android.os.Build;
import android.util.AttributeSet;
import android.widget.ScrollView;

public class NotifyingScrollView
extends ScrollView {
    private boolean mDisableEdgeEffects = true;
    private OnScrollChangedListener mOnScrollChangedListener;

    public NotifyingScrollView(Context context) {
        super(context);
    }

    public NotifyingScrollView(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public NotifyingScrollView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
    }

    protected void onScrollChanged(int l, int t, int oldl, int oldt) {
        super.onScrollChanged(l, t, oldl, oldt);
        if (this.mOnScrollChangedListener != null) {
            this.mOnScrollChangedListener.onScrollChanged(this, l, t, oldl, oldt);
        }
    }

    public void setOnScrollChangedListener(OnScrollChangedListener listener) {
        this.mOnScrollChangedListener = listener;
    }

    protected float getTopFadingEdgeStrength() {
        if (this.mDisableEdgeEffects && Build.VERSION.SDK_INT < 11) {
            return 0.0f;
        }
        return super.getTopFadingEdgeStrength();
    }

    protected float getBottomFadingEdgeStrength() {
        if (this.mDisableEdgeEffects && Build.VERSION.SDK_INT < 11) {
            return 0.0f;
        }
        return super.getBottomFadingEdgeStrength();
    }

    public static interface OnScrollChangedListener {
        public void onScrollChanged(ScrollView var1, int var2, int var3, int var4, int var5);
    }
}

