/*
 * Decompiled with CFR 0.152.
 */
package com.achep.header2actionbar;

import android.app.Activity;
import android.app.Fragment;
import android.content.Context;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AbsListView;
import android.widget.FrameLayout;
import android.widget.LinearLayout;
import android.widget.ListAdapter;
import android.widget.ListView;
import android.widget.ScrollView;
import android.widget.Space;
import com.achep.header2actionbar.NotifyingScrollView;

public abstract class HeaderFragment
extends Fragment {
    private static final String TAG = "HeaderFragment";
    public static final int HEADER_BACKGROUND_SCROLL_NORMAL = 0;
    public static final int HEADER_BACKGROUND_SCROLL_PARALLAX = 1;
    public static final int HEADER_BACKGROUND_SCROLL_STATIC = 2;
    private FrameLayout mFrameLayout;
    private View mContentOverlay;
    private View mHeader;
    private View mHeaderHeader;
    private View mHeaderBackground;
    private int mHeaderHeight;
    private int mHeaderScroll;
    private int mHeaderBackgroundScrollMode = 0;
    private Space mFakeHeader;
    private boolean isListViewEmpty;
    private AbsListView.OnScrollListener mOnScrollListener;
    private OnHeaderScrollChangedListener mOnHeaderScrollChangedListener;

    public void setOnHeaderScrollChangedListener(OnHeaderScrollChangedListener listener) {
        this.mOnHeaderScrollChangedListener = listener;
    }

    public void setHeaderBackgroundScrollMode(int scrollMode) {
        this.mHeaderBackgroundScrollMode = scrollMode;
    }

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        Activity activity = this.getActivity();
        assert (activity != null);
        this.mFrameLayout = new FrameLayout((Context)activity);
        this.mHeader = this.onCreateHeaderView(inflater, (ViewGroup)this.mFrameLayout);
        this.mHeaderHeader = this.mHeader.findViewById(16908310);
        this.mHeaderBackground = this.mHeader.findViewById(0x1020000);
        assert (this.mHeader.getLayoutParams() != null);
        this.mHeaderHeight = this.mHeader.getLayoutParams().height;
        this.mFakeHeader = new Space((Context)activity);
        this.mFakeHeader.setLayoutParams((ViewGroup.LayoutParams)new AbsListView.LayoutParams(0, this.mHeaderHeight));
        Object content = this.onCreateContentView(inflater, (ViewGroup)this.mFrameLayout);
        if (content instanceof ListView) {
            this.isListViewEmpty = true;
            ListView listView = (ListView)content;
            listView.addHeaderView((View)this.mFakeHeader);
            listView.setOnScrollListener(new AbsListView.OnScrollListener(){

                public void onScrollStateChanged(AbsListView absListView, int scrollState) {
                    if (HeaderFragment.this.mOnScrollListener != null) {
                        HeaderFragment.this.mOnScrollListener.onScrollStateChanged(absListView, scrollState);
                    }
                }

                public void onScroll(AbsListView absListView, int firstVisibleItem, int visibleItemCount, int totalItemCount) {
                    if (HeaderFragment.this.isListViewEmpty) {
                        HeaderFragment.this.scrollHeaderTo(0);
                    } else {
                        View child = absListView.getChildAt(0);
                        assert (child != null);
                        HeaderFragment.this.scrollHeaderTo(child == HeaderFragment.this.mFakeHeader ? child.getTop() : -HeaderFragment.this.mHeaderHeight);
                    }
                }
            });
        } else {
            LinearLayout view = new LinearLayout((Context)activity);
            view.setLayoutParams(new ViewGroup.LayoutParams(-1, -1));
            view.setOrientation(1);
            view.addView((View)this.mFakeHeader);
            view.addView(content);
            NotifyingScrollView scrollView = new NotifyingScrollView((Context)activity);
            scrollView.addView((View)view);
            scrollView.setOnScrollChangedListener(new NotifyingScrollView.OnScrollChangedListener(){

                @Override
                public void onScrollChanged(ScrollView who, int l, int t, int oldl, int oldt) {
                    HeaderFragment.this.scrollHeaderTo(-t);
                }
            });
            content = scrollView;
        }
        this.mFrameLayout.addView(content);
        this.mFrameLayout.addView(this.mHeader);
        this.mContentOverlay = this.onCreateContentOverlayView(inflater, (ViewGroup)this.mFrameLayout);
        if (this.mContentOverlay != null) {
            this.mFrameLayout.addView(this.mContentOverlay, (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
        }
        this.mFrameLayout.post(new Runnable(){

            @Override
            public void run() {
                HeaderFragment.this.scrollHeaderTo(0, true);
            }
        });
        return this.mFrameLayout;
    }

    private void scrollHeaderTo(int scrollTo) {
        this.scrollHeaderTo(scrollTo, false);
    }

    private void scrollHeaderTo(int scrollTo, boolean forceChange) {
        this.mHeaderScroll = scrollTo = Math.min(Math.max(scrollTo, -this.mHeaderHeight), 0);
        if (this.mHeaderScroll == this.mHeaderScroll & !forceChange) {
            return;
        }
        this.setViewTranslationY(this.mHeader, scrollTo);
        this.setViewTranslationY(this.mHeaderHeader, -scrollTo);
        switch (this.mHeaderBackgroundScrollMode) {
            case 0: {
                this.setViewTranslationY(this.mHeaderBackground, 0.0f);
                break;
            }
            case 1: {
                this.setViewTranslationY(this.mHeaderBackground, (float)(-scrollTo) / 1.6f);
                break;
            }
            case 2: {
                this.setViewTranslationY(this.mHeaderBackground, -scrollTo);
            }
        }
        if (this.mContentOverlay != null) {
            ViewGroup.LayoutParams lp = this.mContentOverlay.getLayoutParams();
            int delta = this.mHeaderHeight + scrollTo;
            lp.height = this.mFrameLayout.getHeight() - delta;
            this.mContentOverlay.setLayoutParams(lp);
            this.mContentOverlay.setTranslationY((float)delta);
        }
        this.notifyOnHeaderScrollChangeListener((float)(-scrollTo) / (float)this.mHeaderHeight, this.mHeaderHeight, -scrollTo);
    }

    private void setViewTranslationY(View view, float translationY) {
        if (view != null) {
            view.setTranslationY(translationY);
        }
    }

    private void notifyOnHeaderScrollChangeListener(float progress, int height, int scroll) {
        if (this.mOnHeaderScrollChangedListener != null) {
            this.mOnHeaderScrollChangedListener.onHeaderScrollChanged(progress, height, scroll);
        }
    }

    public abstract View onCreateHeaderView(LayoutInflater var1, ViewGroup var2);

    public abstract View onCreateContentView(LayoutInflater var1, ViewGroup var2);

    public abstract View onCreateContentOverlayView(LayoutInflater var1, ViewGroup var2);

    public void setListViewAdapter(ListView listView, ListAdapter adapter) {
        this.isListViewEmpty = adapter == null;
        listView.setAdapter(null);
        listView.removeHeaderView((View)this.mFakeHeader);
        listView.addHeaderView((View)this.mFakeHeader);
        listView.setAdapter(adapter);
    }

    public void setListViewOnScrollChangedListener(AbsListView.OnScrollListener listener) {
        this.mOnScrollListener = listener;
    }

    public View getHeaderView() {
        return this.mHeader;
    }

    public View getHeaderHeaderView() {
        return this.mHeaderHeader;
    }

    public View getHeaderBackgroundView() {
        return this.mHeaderBackground;
    }

    public int getHeaderBackgroundScrollMode() {
        return this.mHeaderBackgroundScrollMode;
    }

    public static interface OnHeaderScrollChangedListener {
        public void onHeaderScrollChanged(float var1, int var2, int var3);
    }
}

